

<?php $__env->startSection('title', 'Edit Jadwal Pelajaran'); ?>

<?php $__env->startSection('content_header'); ?>
<div class="flex justify-between items-center">
    <div>
        <h1 class="text-3xl font-extrabold text-gray-800 flex items-center">
            <i class="fas fa-edit text-amber-500 mr-3"></i> Edit Jadwal Pelajaran
        </h1>
        <p class="text-sm text-gray-500 mt-1">Edit jadwal pelajaran kelas <?php echo e($schedule->class->grade); ?> <?php echo e($schedule->class->name); ?>.</p>
    </div>
    <a href="<?php echo e(route('admin.schedules.show', $schedule->class_id)); ?>" class="text-sm font-bold text-gray-600 hover:text-indigo-600 transition">
        <i class="fas fa-arrow-left mr-1"></i> Kembali
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100">
            <div class="p-8">
                
                <?php if($errors->any()): ?>
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6 rounded-r-lg">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="fas fa-exclamation-circle text-red-500"></i>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-red-800">Terdapat kesalahan pada inputan Anda:</h3>
                                <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('admin.schedules.update', $schedule->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    
                    <input type="hidden" name="class_id" value="<?php echo e($schedule->class_id); ?>">

                    <div class="space-y-6">
                        
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Kelas</label>
                            <input type="text" value="<?php echo e($schedule->class->grade); ?> <?php echo e($schedule->class->name); ?>" disabled
                                   class="bg-gray-100 block w-full sm:text-sm border-gray-300 rounded-xl py-3 text-gray-500">
                        </div>

                        
                        <div>
                            <label for="day" class="block text-sm font-bold text-gray-700 mb-2">
                                Hari <span class="text-red-500">*</span>
                            </label>
                            <div class="relative rounded-xl shadow-sm">
                                <select name="day" id="day" required class="focus:ring-amber-500 focus:border-amber-500 block w-full pl-3 sm:text-sm border-gray-300 rounded-xl py-3">
                                    <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($day); ?>" <?php echo e(old('day', $schedule->day) == $day ? 'selected' : ''); ?>><?php echo e($day); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div>
                            <label for="subject_id" class="block text-sm font-bold text-gray-700 mb-2">
                                Mata Pelajaran <span class="text-red-500">*</span>
                            </label>
                            <div class="relative rounded-xl shadow-sm">
                                <select name="subject_id" id="subject_id" required class="focus:ring-amber-500 focus:border-amber-500 block w-full pl-3 sm:text-sm border-gray-300 rounded-xl py-3">
                                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($subject->id); ?>" <?php echo e(old('subject_id', $schedule->subject_id) == $subject->id ? 'selected' : ''); ?>>
                                            <?php echo e($subject->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label for="start_time" class="block text-sm font-bold text-gray-700 mb-2">
                                    Jam Mulai <span class="text-red-500">*</span>
                                </label>
                                <input type="time" name="start_time" id="start_time" value="<?php echo e(old('start_time', \Carbon\Carbon::parse($schedule->start_time)->format('H:i'))); ?>" required 
                                       class="focus:ring-amber-500 focus:border-amber-500 block w-full sm:text-sm border-gray-300 rounded-xl py-3">
                            </div>
                            <div>
                                <label for="end_time" class="block text-sm font-bold text-gray-700 mb-2">
                                    Jam Selesai <span class="text-red-500">*</span>
                                </label>
                                <input type="time" name="end_time" id="end_time" value="<?php echo e(old('end_time', \Carbon\Carbon::parse($schedule->end_time)->format('H:i'))); ?>" required 
                                       class="focus:ring-amber-500 focus:border-amber-500 block w-full sm:text-sm border-gray-300 rounded-xl py-3">
                            </div>
                        </div>
                    </div>

                    <div class="mt-8 pt-6 border-t border-gray-100 flex items-center justify-end space-x-3">
                        <a href="<?php echo e(route('admin.schedules.show', $schedule->class_id)); ?>" class="bg-gray-100 text-gray-700 font-bold py-3 px-6 rounded-xl hover:bg-gray-200 transition duration-200">
                            Batal
                        </a>
                        <button type="submit" class="bg-gradient-to-r from-amber-500 to-orange-600 hover:from-amber-600 hover:to-orange-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg transform transition hover:-translate-y-1">
                            <i class="fas fa-save mr-2"></i> Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlte', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\e-absensi-siswa\resources\views/admin/schedules/edit.blade.php ENDPATH**/ ?>