

<?php
    // --- LOGIKA PHP (Tidak Diubah) ---
    $settings = $settings ?? \App\Models\Setting::pluck('value', 'key')->toArray();
    $schoolName = $settings['school_name'] ?? 'E-Absensi Sekolah';
?>


<footer class="mt-8 pt-4 pb-20 md:pb-6 
                bg-gray-100/50 border-t border-gray-200 
                text-sm text-gray-600 
                px-4 sm:px-6 
                transition-all duration-300 ease-in-out">

    
    <div class="flex flex-col sm:flex-row justify-between items-start w-full max-w-7xl mx-auto">
        
        
        <div class="order-1 sm:order-2 mb-2 sm:mb-0 text-xs text-right w-full sm:w-auto">
             <span class="text-gray-400">Versi: </span>
             <strong class="font-medium text-gray-500">v1.1.0</strong>
        </div>
        
        
        <div class="order-2 sm:order-1 text-left w-full sm:w-auto">
            <strong class="font-semibold text-gray-700">
                Copyright &copy; <?php echo e(date('Y')); ?> 
                
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-indigo-600 hover:text-indigo-800 font-bold">
                    <?php echo e($schoolName); ?>

                </a>.
            </strong> 
            <span class="block sm:inline text-xs text-gray-500 font-light mt-1 sm:mt-0">
                All rights reserved. Dibuat dengan <i class="fas fa-heart text-red-500"></i>
            </span>
        </div>
    </div>
</footer><?php /**PATH C:\xampp\htdocs\e-absensi-siswa\resources\views/layouts/partials/footer.blade.php ENDPATH**/ ?>