

<?php $__env->startSection('title', 'Jadwal Pelajaran'); ?>

<?php $__env->startSection('content_header'); ?>
<div class="flex justify-between items-center">
    <div>
        <h1 class="text-3xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-purple-600 to-indigo-600 flex items-center">
            <i class="far fa-calendar-alt text-purple-600 mr-3"></i> Jadwal Pelajaran
        </h1>
        <p class="text-sm text-gray-500 mt-1 font-medium">Jadwal mata pelajaran ananda minggu ini.</p>
    </div>
    <a href="<?php echo e(route('orangtua.dashboard')); ?>" class="text-sm font-bold text-gray-600 hover:text-indigo-600 transition">
        <i class="fas fa-arrow-left mr-1"></i> Dashboard
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <?php $__currentLoopData = $schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentName => $studentSchedules): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100 mb-8">
            <div class="bg-gradient-to-r from-indigo-500 to-purple-600 px-6 py-4 flex justify-between items-center">
                <h3 class="text-xl font-bold text-white flex items-center">
                    <i class="fas fa-user-graduate mr-3 text-yellow-300"></i> <?php echo e($studentName); ?>

                </h3>
            </div>
            
            <div class="p-6">
                
                <div x-data="{ activeTab: '<?php echo e(now()->locale('id')->translatedFormat('l')); ?>' }">
                    
                    <div class="flex space-x-2 overflow-x-auto pb-4 mb-4 border-b border-gray-100 no-scrollbar">
                        <?php $__currentLoopData = ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button @click="activeTab = '<?php echo e($day); ?>'" 
                                    :class="{ 'bg-indigo-600 text-white shadow-md': activeTab === '<?php echo e($day); ?>', 'bg-gray-50 text-gray-600 hover:bg-gray-100': activeTab !== '<?php echo e($day); ?>' }"
                                    class="px-4 py-2 rounded-xl text-sm font-bold transition duration-200 whitespace-nowrap">
                                <?php echo e($day); ?>

                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    
                    <?php $__currentLoopData = ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div x-show="activeTab === '<?php echo e($day); ?>'" 
                             x-transition:enter="transition ease-out duration-300"
                             x-transition:enter-start="opacity-0 transform scale-95"
                             x-transition:enter-end="opacity-100 transform scale-100"
                             class="space-y-3">
                            
                            <?php if(isset($studentSchedules[$day]) && count($studentSchedules[$day]) > 0): ?>
                                <?php $__currentLoopData = $studentSchedules[$day]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center p-4 bg-white rounded-2xl border border-gray-100 shadow-sm hover:shadow-md transition duration-200 group">
                                        <div class="flex-shrink-0 w-16 h-16 bg-indigo-50 rounded-xl flex flex-col items-center justify-center text-indigo-600 border border-indigo-100 group-hover:bg-indigo-600 group-hover:text-white transition duration-300">
                                            <span class="text-xs font-bold"><?php echo e(\Carbon\Carbon::parse($schedule->start_time)->format('H:i')); ?></span>
                                            <span class="text-[10px] opacity-75">s/d</span>
                                            <span class="text-xs font-bold"><?php echo e(\Carbon\Carbon::parse($schedule->end_time)->format('H:i')); ?></span>
                                        </div>
                                        <div class="ml-4 flex-1">
                                            <h4 class="text-lg font-bold text-gray-800 group-hover:text-indigo-600 transition duration-200">
                                                <?php echo e($schedule->subject->name); ?>

                                            </h4>
                                            <?php if($schedule->subject->code): ?>
                                                <span class="text-xs font-mono text-gray-400 bg-gray-50 px-2 py-0.5 rounded"><?php echo e($schedule->subject->code); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="ml-auto">
                                            <i class="fas fa-book-reader text-gray-300 group-hover:text-indigo-200 text-2xl transition duration-300"></i>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="text-center py-12">
                                    <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gray-50 mb-4">
                                        <i class="far fa-calendar-check text-gray-300 text-2xl"></i>
                                    </div>
                                    <h3 class="text-lg font-medium text-gray-900">Tidak ada jadwal</h3>
                                    <p class="text-gray-500 text-sm">Hari ini tidak ada KBM atau libur.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    /* Hide scrollbar for Chrome, Safari and Opera */
    .no-scrollbar::-webkit-scrollbar {
        display: none;
    }
    /* Hide scrollbar for IE, Edge and Firefox */
    .no-scrollbar {
        -ms-overflow-style: none;  /* IE and Edge */
        scrollbar-width: none;  /* Firefox */
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlte', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\e-absensi-siswa\resources\views/orangtua/jadwal/index.blade.php ENDPATH**/ ?>