

<?php
    // --- Logika PHP (TIDAK BERUBAH) ---
    use Illuminate\Support\Str;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\Facades\Request;

    $user = Auth::user();
    $settings = $settings ?? \App\Models\Setting::pluck('value', 'key')->toArray();
    $schoolName = $settings['school_name'] ?? 'E-Absensi Siswa';
    $schoolLogoPath = $settings['school_logo'] ?? null;
    $scanIconColor = 'text-red-500'; // Warna ikon Scan tetap

    // Penanganan Active State (TIDAK BERUBAH)
    $isAbsensiAdminActive = Request::is('admin/absensi/scan-kelas');
    $isManajemenDataActive =
        Request::is('admin/classes*') ||
        Request::is('admin/students*') ||
        Request::is('admin/teachers*') ||
        Request::is('admin/parents*') ||
        Request::is('admin/users*');
    $isAbsensiWaliKelasActive = Request::is('walikelas/absensi*');

    function isActive($path)
    {
        return Request::is($path);
    }

    // Class Tailwind untuk Styling (PEMBARUAN WARNA)
    // Mengganti blue-600 dengan indigo-600 untuk estetika yang lebih modern
    $activeClass = 'bg-indigo-600 text-white font-semibold shadow-md';
    $defaultClass = 'text-gray-300 hover:bg-gray-700/70 hover:text-white'; // Hover lebih menonjol
    // Menggunakan warna indigo yang lebih terang untuk sub-menu
    $activeSubClass = 'bg-indigo-700/50 text-white font-medium';
    $defaultSubClass = 'text-gray-400 hover:bg-gray-700/50 hover:text-white';
?>

<aside id="main-sidebar"
    class="fixed top-0 left-0 z-50 h-full w-64 bg-gray-900 
           transform -translate-x-full md:translate-x-0 transition-transform duration-300 ease-in-out shadow-[4px_0_24px_rgba(0,0,0,0.1)] border-r border-gray-800">

    
    
    <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center p-4 py-3 border-b border-gray-700">

        
        <?php if($schoolLogoPath): ?>
            
            <img src="<?php echo e(asset('storage/' . $schoolLogoPath)); ?>" alt="<?php echo e($schoolName); ?>"
                class="h-8 w-8 rounded-full object-cover mr-3 border-2 border-indigo-500/50">
        <?php else: ?>
            
            <i
                class="fas fa-clipboard-check text-white h-8 w-8 rounded-full bg-indigo-600 flex items-center justify-center mr-3 text-base"></i>
        <?php endif; ?>

        
        <div class="flex flex-col overflow-hidden leading-snug">
            
            <span class="text-white text-sm font-extrabold whitespace-nowrap overflow-ellipsis">
                <?php echo e(Str::limit($schoolName, 20)); ?>

            </span>
            <small class="text-gray-400 text-xs font-light mt-0">E-Absensi Digital</small>
        </div>
    </a>

    
    
    <div class="overflow-y-auto h-[calc(100vh-62px)] p-4">
        <nav>
            <ul class="space-y-2">

                <?php if($user): ?>
                    
                    <?php if($user->isSuperAdmin()): ?>
                        
                        <li
                            class="px-2 pt-3 pb-1 text-xs font-semibold text-indigo-400 uppercase border-t border-gray-700 mt-2 flex justify-between items-center">
                            <span>ADMINISTRASI PUSAT</span>
                            <i class="fas fa-cogs text-indigo-500/70"></i>
                        </li>

                        
                        <li>
                            
                            <a href="<?php echo e(route('admin.dashboard')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('admin/dashboard') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-tachometer-alt w-5 h-5 mr-3"></i>
                                <span class="text-sm">Dashboard</span>
                            </a>
                        </li>

                        
                        <li class="relative">
                            
                            <button
                                onclick="document.getElementById('submenu-manajemen-data').classList.toggle('hidden');"
                                class="w-full flex items-center p-2.5 rounded-md transition duration-150 <?php echo e($isManajemenDataActive ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-database w-5 h-5 mr-3"></i>
                                <span class="flex-1 text-sm whitespace-nowrap text-left">Manajemen Data</span>
                                <i
                                    class="fas fa-angle-left right ml-auto transition-transform duration-200 <?php echo e($isManajemenDataActive ? '-rotate-90' : 'rotate-0'); ?>"></i>
                            </button>

                            
                            <ul id="submenu-manajemen-data"
                                class="pl-2 pt-1 space-y-1 <?php echo e($isManajemenDataActive ? 'block' : 'hidden'); ?>">
                                <?php $__currentLoopData = [
        'classes.index' => ['route' => 'classes.index', 'text' => 'Data Kelas'],
        'students.index' => ['route' => 'students.index', 'text' => 'Data Siswa'],
        'teachers.index' => ['route' => 'teachers.index', 'text' => 'Data Wali Kelas'],
        'parents.index' => ['route' => 'parents.index', 'text' => 'Data Orang Tua'],
        'admin.users.index' => ['route' => 'admin.users.index', 'text' => 'Manajemen Pengguna'],
    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routeKey => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(route($routeKey)); ?>"
                                            class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                    <?php echo e(Request::is('admin/' . str_replace('.index', '*', Str::after($routeKey, 'admin.'))) ? $activeSubClass : $defaultSubClass); ?>">
                                            <i class="far fa-dot-circle text-xs w-3 h-3 mr-3 opacity-75"></i>
                                            <span class="ml-1"><?php echo e($item['text']); ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <li>
                                    <a href="<?php echo e(route('admin.subjects.index')); ?>"
                                        class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                <?php echo e(isActive('admin/subjects*') ? $activeSubClass : $defaultSubClass); ?>">
                                        <i class="fas fa-book-open text-xs w-3 h-3 mr-3 opacity-75"></i>
                                        <span class="ml-1">Mata Pelajaran</span>
                                    </a>
                                </li>
                                
                                <li>
                                    <a href="<?php echo e(route('admin.schedules.index')); ?>"
                                        class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                <?php echo e(isActive('admin/schedules*') ? $activeSubClass : $defaultSubClass); ?>">
                                        <i class="far fa-calendar-alt text-xs w-3 h-3 mr-3 opacity-75"></i>
                                        <span class="ml-1">Atur Jadwal</span>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        
                        <li
                            class="px-2 pt-3 pb-1 text-xs font-semibold text-indigo-400 uppercase border-t border-gray-700 mt-2 flex justify-between items-center">
                            <span>LAPORAN & PENGATURAN</span>
                            <i class="fas fa-chart-line text-indigo-500/70"></i>
                        </li>

                        
                        <?php $__currentLoopData = [
        'report.index' => ['icon' => 'fas fa-chart-line', 'text' => 'Laporan Absensi', 'route_path' => 'admin/report*'],
        'settings.index' => ['icon' => 'fas fa-cog', 'text' => 'Pengaturan Umum', 'route_path' => 'admin/settings*'],
    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $routeKey => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route($routeKey)); ?>"
                                    class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive($item['route_path']) ? $activeClass : $defaultClass); ?>">
                                    <i class="<?php echo e($item['icon']); ?> w-5 h-5 mr-3"></i>
                                    <span class="text-sm"><?php echo e($item['text']); ?></span>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <li>
                            <a href="<?php echo e(route('announcements.index')); ?>"
                               class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('admin/announcements*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-bullhorn w-5 h-5 mr-3"></i>
                                <span class="text-sm">Kelola Pengumuman</span>
                            </a>
                        </li>

                        
                        <li
                            class="px-2 pt-3 pb-1 text-xs font-semibold text-indigo-400 uppercase border-t border-gray-700 mt-2 flex justify-between items-center">
                            <span>OPERASI UTAMA</span>
                            <i class="fas fa-camera text-indigo-500/70"></i>
                        </li>

                        
                        <li>
                            <a href="<?php echo e(route('admin.absensi.scan')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e($isAbsensiAdminActive ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-qrcode w-5 h-5 mr-3 <?php echo e($scanIconColor); ?>"></i>
                                <span class="text-sm">Absensi QR Scan</span>
                            </a>
                        </li>

                        
                    <?php elseif($user->isWaliKelas()): ?>
                        <li
                            class="px-2 pt-3 pb-1 text-xs font-semibold text-indigo-400 uppercase border-t border-gray-700 mt-2 flex justify-between items-center">
                            <span>AREA WALI KELAS</span>
                            <i class="fas fa-user-tie text-indigo-500/70"></i>
                            </li>
                        
                        
                        <li>
                            <a href="<?php echo e(route('walikelas.dashboard')); ?>"
                                
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('walikelas/dashboard') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-home w-5 h-5 mr-3"></i>
                                <span class="text-sm">Dashboard Kelas</span>
                                </a>
                            </li>
                        
                        
                        <li>
                            <a href="<?php echo e(route('walikelas.students.index')); ?>"
                                
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('walikelas/students*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-users w-5 h-5 mr-3"></i>
                                <span class="text-sm">Data Siswa Kelas</span>
                                </a>
                            </li>
                        
                        
                        <li>
                            <a href="<?php echo e(route('walikelas.izin.index')); ?>"
                                
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('walikelas/izin*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-envelope-open-text w-5 h-5 mr-3"></i>
                                <span class="text-sm">Permintaan Izin</span>
                                </a>
                            </li>
                        
                        
                        <li class="relative">
                            <button
                                onclick="document.getElementById('submenu-walikelas-absensi').classList.toggle('hidden');"
                                
                                class="w-full flex items-center p-2.5 rounded-md transition duration-150 <?php echo e($isAbsensiWaliKelasActive ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-calendar-check w-5 h-5 mr-3"></i>
                                <span
                                    class="flex-1 text-sm whitespace-nowrap text-left">Absensi Kelas</span>
                                <i
                                    class="fas fa-angle-left right ml-auto transition-transform duration-200 <?php echo e($isAbsensiWaliKelasActive ? '-rotate-90' : 'rotate-0'); ?>"></i>
                                </button>
                            
                            <ul id="submenu-walikelas-absensi"
                                class="pl-2 pt-1 space-y-1 <?php echo e($isAbsensiWaliKelasActive ? 'block' : 'hidden'); ?>">
                                <li>
                                    <a href="<?php echo e(route('walikelas.absensi.scan')); ?>"
                                        
                                        class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                <?php echo e(isActive('walikelas/absensi/scan') ? $activeSubClass : $defaultSubClass); ?>">
                                        <i
                                            class="fas fa-qrcode text-xs w-3 h-3 mr-3 opacity-75"></i>
                                        <span class="ml-1">Scan
                                            Masuk/Pulang</span>
                                        </a>
                                    </li>
                                <li>
                                    <a
                                        href="<?php echo e(route('walikelas.absensi.manual.index')); ?>"
                                        
                                        class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                <?php echo e(isActive('walikelas/absensi/manual*') ? $activeSubClass : $defaultSubClass); ?>">
                                        <i
                                            class="fas fa-edit text-xs w-3 h-3 mr-3 opacity-75"></i>
                                        <span class="ml-1">Manual &
                                            Koreksi</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        
                        
                        <li class="relative">
                            <button
                                onclick="document.getElementById('submenu-walikelas-report').classList.toggle('hidden');"
                                
                                class="w-full flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('walikelas/report*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-chart-bar w-5 h-5 mr-3"></i>
                                <span
                                    class="flex-1 text-sm whitespace-nowrap text-left">Riwayat & Laporan</span>
                                <i
                                    class="fas fa-angle-left right ml-auto transition-transform duration-200 <?php echo e(isActive('walikelas/report*') ? '-rotate-90' : 'rotate-0'); ?>"></i>
                                </button>
                            
                            
                            <ul id="submenu-walikelas-report"
                                class="pl-2 pt-1 space-y-1 <?php echo e(isActive('walikelas/report*') ? 'block' : 'hidden'); ?>">
                                <li>
                                    <a href="<?php echo e(route('walikelas.report.index')); ?>"
                                        
                                        class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                <?php echo e(isActive('walikelas/report') && !isActive('walikelas/report/monthly-recap') ? $activeSubClass : $defaultSubClass); ?>">
                                        <i
                                            class="fas fa-list-alt text-xs w-3 h-3 mr-3 opacity-75"></i>
                                        <span class="ml-1">Laporan
                                            Harian</span>
                                        </a>
                                    </li>
                                <li>
                                    <a
                                        href="<?php echo e(route('walikelas.report.monthly_recap')); ?>"
                                        
                                        class="flex items-center p-2 rounded-md transition duration-150 text-sm 
                                                <?php echo e(isActive('walikelas/report/monthly-recap') ? $activeSubClass : $defaultSubClass); ?>">
                                        <i
                                            class="fas fa-calendar-alt text-xs w-3 h-3 mr-3 opacity-75"></i>
                                        <span class="ml-1">Rekap Absensi
                                            Bulanan</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>

                        
                    <?php elseif($user->isOrangTua()): ?>
                        <li
                            class="px-2 pt-3 pb-1 text-xs font-semibold text-indigo-400 uppercase border-t border-gray-700 mt-2 flex justify-between items-center">
                            <span>AREA ORANG TUA</span>
                            <i class="fas fa-users text-indigo-500/70"></i>
                        </li>

                        
                        <li>
                            <a href="<?php echo e(route('orangtua.dashboard')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('orangtua/dashboard') && !isActive('orangtua/report*') && !isActive('orangtua/izin*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-tachometer-alt w-5 h-5 mr-3"></i>
                                <span class="text-sm">Dashboard</span>
                            </a>
                        </li>

                        
                        <li>
                            <a href="<?php echo e(route('orangtua.report.index')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('orangtua/report*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-list-alt w-5 h-5 mr-3"></i>
                                <span class="text-sm">Riwayat Absensi Anak</span>
                            </a>
                        </li>

                        
                        <li>
                            <a href="<?php echo e(route('orangtua.izin.index')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('orangtua/izin*') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-file-medical-alt w-5 h-5 mr-3"></i>
                                <span class="text-sm">Pengajuan Izin/Sakit</span>
                            </a>
                        </li>

                        
                        <li>
                            <a href="<?php echo e(route('orangtua.jadwal.index')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('orangtua/jadwal*') ? $activeClass : $defaultClass); ?>">
                                <i class="far fa-calendar-alt w-5 h-5 mr-3"></i>
                                <span class="text-sm">Jadwal Pelajaran</span>
                            </a>
                        </li>

                        
                        <li class="border-t border-gray-700 pt-2 mt-2">
                            <a href="<?php echo e(route('profile.edit')); ?>"
                                class="flex items-center p-2.5 rounded-md transition duration-150 <?php echo e(isActive('profile') ? $activeClass : $defaultClass); ?>">
                                <i class="fas fa-user w-5 h-5 mr-3"></i>
                                <span class="text-sm">Edit Profil</span>
                            </a>
                        </li>
                    <?php endif; ?> 

                <?php endif; ?> 
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH C:\xampp\htdocs\e-absensi-siswa\resources\views/layouts/partials/sidebar.blade.php ENDPATH**/ ?>